import logging

import asn1tools
from pathlib import Path

from pprint import pprint

ignoreReleases = {'33108' : [f'r{i}' for i in range(5, 17)],
                  '33128' : [] }

def prepareFile(f):
    with open(f) as fh:
        s = fh.read()
    s = s.replace("RELATIVE-OID", "OBJECT IDENTIFIER") # sigh
    return s

if __name__ == '__main__':
    fileList = list(Path(".").rglob("*.asn1")) + list(Path(".").rglob("*.asn"))

    ignoredFiles = [file for file in fileList if file.parts[1] in ignoreReleases[file.parts[0]]]
    logging.info(f"Ignoring {len(ignoredFiles)} files")
    logging.debug(ignoredFiles)
    
    fileList = [file for file in fileList if file not in ignoredFiles]

    if len(fileList) == 0:
        logging.warning ("No files specified")
        exit(0)

    print ("ASN.1 Compilation checks:")
    print ("-----------------------------")    
    logging.info("Parsing files...")
    errorCount = 0
    for f in fileList:
        try:
            s = prepareFile(str(f))
            asn1tools.compile_string(s) # this won't work for modules with IMPORTs
        except asn1tools.ParseError as ex:
            logging.info (f"  {f}: Failed - {ex!r}")
            print (f"  {f}: Failed - {ex!r}")
            errorCount += 1
            continue
        print (f"  {f}: OK")
    print ("-----------------------------")    
    print (f"Compile errors: {errorCount}")
    print ("-----------------------------")    
    exit(errorCount)
