import logging

from asn1tools import parse_files, ParseError
from pathlib import Path

from pprint import pprint

ignoreReleases = {'33108' : [f'r{i}' for i in range(5, 16)],
                  '33128' : [] }

if __name__ == '__main__':
    fileList = list(Path(".").rglob("*.asn1")) + list(Path(".").rglob("*.asn"))

    ignoredFiles = [file for file in fileList if file.parts[1] in ignoreReleases[file.parts[0]]]
    logging.info(f"Ignoring {len(ignoredFiles)} files")
    logging.debug(ignoredFiles)
    
    fileList = [file for file in fileList if file not in ignoredFiles]

    if len(fileList) == 0:
        logging.warning ("No files specified")
        exit(0)

    print ("ASN.1 Parser checks:")
    print ("-----------------------------")    
    logging.info("Parsing files...")
    errorCount = 0
    for f in fileList:
        try:
            parse_files(str(f))
        except ParseError as ex:
            logging.info (f"  {f}: Failed - {ex!r}")
            print (f"  {f}: Failed - {ex!r}")
            errorCount += 1
            continue
        print (f"  {f}: OK")
    print ("-----------------------------")    
    print (f"Parse errors: {errorCount}")
    print ("-----------------------------")    
    exit(errorCount)
