#!/bin/bash
# Copyright ETSI 2021
# See: https://forge.etsi.org/etsi-forge-copyright-statement.txt
# If there are no YAML file, simply exit
ls | grep -q yaml
found_yaml=$?
if [ ! $found_yaml ] ; then 
    echo "-- No YAML files."
    exit 0
fi

echo "------ Installing necessary node modules -----"

#npm install js-yaml
#npm install json

echo "------ Generating CONFIG file from all YAML files ------"
fres=0

for i in *.yaml ;  do
	echo "[$i]"
	echo "[$i]" | grep -Po "TS[\w-]+\.yaml" | xargs -I % sh -c 'echo [%]' >> api-versions.txt ;
    # node ./node_modules/js-yaml/bin/js-yaml $i > "$i.json" ;
    # cat "$i.json" | node ./node_modules/json/lib/json info.version >> api-versions.txt

    # input=$(cat "$i.json" | node ./node_modules/json/lib/json externalDocs.description)
    # pattern="[0-9]+[.][0-9]+[.][0-9]+"
    # if echo $input | grep -qPo $pattern
    # then
      # echo $input | grep -Po $pattern >> api-versions.txt
    # else
      # echo "-" >> api-versions.txt
    # fi

    # # cat "$i.json" | node ./scripts/node_modules/json/lib/json externalDocs.description | grep -Po "[0-9]+[.][0-9]+[.][0-9]+" >> api-versions.txt

    # cat "$i.json" | node ./node_modules/json/lib/json info.description | grep -Po "[0-9]{4}" >> api-versions.txt
	
	#node ./node_modules/js-yaml/bin/js-yaml $i|node ./node_modules/json/lib/json  info.version externalDocs.description info.description |grep -Po "[0-9]+[.][0-9]+[.][0-9]+|[0-9]{4}" >>api-versions.txt
    FILE="${i}"
	INFO_VERSION=`sed -n '/^info:/,/^[^[:space:]]/{/^  version:/p;/^[^([:space:]|info:)]/q}' ${FILE} | grep -Po '([0-9]+\.){2}[0-9]+(-alpha.[0-9]+)?'` #>> api-versions.txt #Info version
	if [ "$INFO_VERSION" == "" ]; then
		echo "-" >>api-versions.txt
	else
		echo $INFO_VERSION >> api-versions.txt
	fi
	EXT_DOC_VERSION=`sed -n '/^externalDocs:/,/^[^[:space:]]/{/^  description:/,/^[^[:space:]]/p;/^[^([:space:]|externalDocs:)]/q}' ${FILE} | grep -Po '([0-9]+\.){2}[0-9]+'` # >> api-versions.txt # EXT_DOC_VERSION
	if [ "$EXT_DOC_VERSION" == "" ]; then
		echo "-" >>api-versions.txt
	else
		echo $EXT_DOC_VERSION >> api-versions.txt
	fi
	sed -n '/^info:/,/^[^[:space:]]/{/^  description:/,/^[^[:space:]]/p;/^[^([:space:]|info:)]/q}' ${FILE} | grep -Po '[0-9]{4}' >> api-versions.txt
	
	res=$?
    fres=$(($fres||$res))
done
exit $fres
