#!/bin/bash
# Copyright ETSI 2021
# See: https://forge.etsi.org/etsi-forge-copyright-statement.txt
echo "------ Content of the folder ------"
ls

# If there are no YAML file, simply exit
ls | grep -q yaml
found_yaml=$?
if [ ! $found_yaml ] ; then 
    echo "-- No YAML files."
    exit 0
fi

echo "------ Installing necessary node modules -----"

cd scripts
npm install js-yaml
npm install json
cd ..

pwd
echo "------ Removing old CONFIG file ------"
rm -f api-versions.txt

echo "------ Generating CONFIG file from all YAML files ------"

echo "------ Switching to $1 folder --------"
#cd $1
pwd 
fres=0

for i in $1/*.yaml ;  do
	echo "[$i]"
	echo "[$i]" | grep -Po "TS[\w-]+\.yaml" | xargs -I % sh -c 'echo [%]' >> api-versions.txt ;
    node ./scripts/node_modules/js-yaml/bin/js-yaml $i > "$i.json" ;
    cat "$i.json" | node ./scripts/node_modules/json/lib/json info.version >> api-versions.txt

    input=$(cat "$i.json" | node ./scripts/node_modules/json/lib/json externalDocs.description)
    pattern="[0-9]+[.][0-9]+[.][0-9]+"
    if echo $input | grep -qPo $pattern
    then
      echo $input | grep -Po $pattern >> api-versions.txt
    else
      echo "-" >> api-versions.txt
    fi

    # cat "$i.json" | node ./scripts/node_modules/json/lib/json externalDocs.description | grep -Po "[0-9]+[.][0-9]+[.][0-9]+" >> api-versions.txt

    cat "$i.json" | node ./scripts/node_modules/json/lib/json info.description | grep -Po "[0-9]{4}" >> api-versions.txt
    res=$?
    fres=$(($fres||$res))
done

# Exit code needed for jenkins to know the verdict of the build
echo "-- Final validator returns $fres."
exit $fres
