#!/bin/bash

DOCKER_IMAGE=forge.3gpp.org:5050/tools/3gpp-scripts/forgelib:v1.0.0

echo "\n------ Checking for docker image --------"
docker pull "$DOCKER_IMAGE"

echo "------ Removing previous outputs --------"
rm *.docx

echo "------ Parsing repo URL --------"

HOST_URL=$(echo $1 | cut -d'/' -f 1-3)
PROJECT_NAME=$(echo $1 | cut -d'/' -f 5- | cut -d'.' -f 1)
echo "HOST URL:" $HOST_URL
echo "PROJECT NAME:" $PROJECT_NAME
echo "PROJECT ID:" $2
echo "MERGE IID:" $3

echo "\n------ Generating change marks --------"
docker container run --rm -v$(pwd):/tmp/ "$DOCKER_IMAGE" forgelib-changedocs -vv --outPath=/tmp/ "$HOST_URL" "$2" "$PROJECT_NAME" "$3"

exit 0

