#!/bin/sh
# Copyright ETSI 2019-2021
# See: https://forge.etsi.org/etsi-forge-copyright-statement.txt
LOGFILE=openapi-validation.log
echo -e "\n------ Validating all YAML files (may takes several minutes) ------"
# If there are no YAML file, simply exit
ls | grep -q yaml
found_yaml=$?
if [ ! $found_yaml ]
then
    echo "-- No YAML files."
    exit 0
fi
fres=0
LOG=""
ERR=""
for i in specs/*.yaml
do
    MSG=$(swagger-cli validate "$i" 2>&1)
    #MSG=$(validate "$i" 2>&1)
	res=$?
    #echo "$MSG"
    if [ ! $res == 0 ] ; then 
        echo -e "----  Validating $i ... invalid\n$MSG"
        LOG="$LOG\n----  Validating $i ... invalid\n$MSG"
        ERR="$ERR\nFile $i: $MSG\n"
    else
        echo -e "----  Validating $i ... valid"
        LOG="$LOG\n----  Validating $i ... valid"
	fi 
    #LOG="$LOG$MSG\n"
    fres=$(($fres||$res))
done
echo -e "\n-- Final validator returns $fres." | tee -a $LOGFILE
if [ $fres == 0 ]
then
   echo "No errors found, all files validate the OpenAPI definition. Below the complete log." | tee -a $LOGFILE
else
   echo "Some errors found, see below the details." | tee -a $LOGFILE
fi
if [ ! "$ERR" == "" ]
then
    echo -e "\n---- Errors detected ----" | tee -a $LOGFILE
    echo -e $ERR  | tee -a $LOGFILE
fi

echo -e "\n---- Complete log of validation ----" >> $LOGFILE
echo -e $LOG >> $LOGFILE

# echo -e "\n---- Complete log of validation ----" | tee -a $LOGFILE
# echo -e $LOG | tee -a $LOGFILE
#echo -e "\n------ Content of the folder ------" | tee -a $LOGFILE
#ls | tee -a $LOGFILE
mv $LOGFILE specs/
# Exit code needed for jenkins to know the verdict of the build
exit $fres
