#!/bin/bash

DOCKER_IMAGE=forge.3gpp.org:5050/tools/3gpp-scripts/forgelib:v2.17.0

echo "\n------ Checking for docker image --------"
docker pull "$DOCKER_IMAGE"

echo "------ Removing previous outputs --------"
rm **/*.docx

echo "------ Parsing repo URL --------"

HOST_URL=$(echo $1 | cut -d'/' -f 1-4)
PROJECT_NAME=$(echo $1 | cut -d'/' -f 5- | cut -d'.' -f 1)
echo "HOST URL:" $HOST_URL
echo "PROJECT NAME:" $PROJECT_NAME
echo "PROJECT ID:" $2
echo "MERGE IID:" $3

#echo "\n------ Generating patch file --------"
#Getting commit ids for the merge request
#mergeUrl=$HOST_URL/api/v4/projects/$2/merge_requests/$3
#start_sha="$(curl $mergeUrl | grep -Eo \"start_sha\":\"[^\:,]*\" | cut -d':' -f 2 | cut -d'"' -f 2)"
#head_sha="$(curl $mergeUrl | grep -Eo \"head_sha\":\"[^\:,]*\" | cut -d':' -f 2 | cut -d'"' -f 2)"

#Generate patch file
#echo "git diff -p $start_sha $head_sha"
#git diff -p $start_sha $head_sha > merge_patch.patch

echo "\n------ Generating change marks --------"
#Using merge ID to get the diff
docker container run --rm -v $(pwd):/tmp/ "$DOCKER_IMAGE" forgelib-changedocs -vv --combine --filename --preprocessor sa5 --outPath=/tmp/docs --startdelimiter "/tmp/$4" --enddelimiter "/tmp/$5" --coversheet "/tmp/$6" "$HOST_URL" "$2" "$3"
#Using the generated patch file from above (this approach eliminates the issue of diff limit
#docker container run --rm -v $(pwd):/tmp/ "$DOCKER_IMAGE" forgelib-changedocs -vv --combine --outPath=/tmp/docs --patchfile "merge_patch.patch" --startdelimiter "/tmp/$4" --enddelimiter "/tmp/$5" "$HOST_URL" "$2" "$PROJECT_NAME" "$3"

exit 0

