#!/bin/bash
# Copyright ETSI 2020

LOGFILE=yang-linting.txt
DOCKER_IMG=etsiforge/pyang:2.4.0-3gpp-d410f57

echo "------ Switching to $1 folder --------"
cd $1
ls

echo "------ Content of the folder ------"
ls

echo "------ Checking for previous logs ------"
if [ -f "$LOGFILE" ] ; then
	echo "Found previous log. Removing it"
	rm "$LOGFILE"
fi

echo "------ Linting modified YANG files ------"
# If there are no YANG, JSON or XML files, then simply exit
ls | grep -q 'yang'
found_data_models=$?
if [ $found_data_models == 1 ] ; then 
    echo "-- No YANG files." >>$LOGFILE
    exit 0
fi

echo "------ pyYANG Version ------"
#  Display all  errors and warnings to the user. Errors are allowed.
docker pull -q "${DOCKER_IMG}"
docker run --rm -v $(pwd)/yang-models:/yang "${DOCKER_IMG}" pyang --version

echo "------ Linting modified YANG files ------"
# Linting only yang files that have changed in last commit
files_changed=`git log --raw -n 1 |grep "^:.*yang-models/.*yang"| cut -d '/' -f 2`
echo $files_changed
external_files_changed=`git log --raw -n 1 |grep "^:.*yang-models/external-yams/.*yang"| cut -d '/' -f 2`
echo $external_files_modified
if [ -d "changed-yang-models" ]; then
        echo "Removing changed-yang-models dir"
        rm -rf "changed-yang-models"
fi
mkdir changed-yang-models
mkdir changed-yang-models/external-yams
if [ ! -z "$files_changed" ] ; then
        cd yang-models
        cp $files_changed ../changed-yang-models/
        cd ..
fi

if [ ! -z "$external_files_changed" ] ; then
        cd yang-models/external-yams
        cp $external_files_changed ../changed-yang-models/external-yams
        cd ../..
fi

if [ ! -z "$files_changed" ] || [ ! -z "$external_files_changed" ] ; then
	docker run --rm -v $(pwd):/yang "${DOCKER_IMG}" "/bin/sh" -c 'pyang --3gpp -p yang-models -p yang-models/external-yams changed-yang-models/*.yang' 2>>$LOGFILE >>$LOGFILE
	ret=$?        
else
    echo "-- No YANG files modified." >>$LOGFILE
    exit 0
fi

#Validate all yang files
#docker run --rm -v $(pwd)/yang-models:/yang "${DOCKER_IMG}" "/bin/sh" -c 'pyang --3gpp -p external-yams _3gpp-*.yang' 2>>$LOGFILE >>$LOGFILE
#ret=$?

echo "Output of Linting commad saved to $LOGFILE."

echo "------ Linting result ------"
echo $ret

if [ $ret == 1 ] ; then
	echo "Some issues were collected by the linter, but they are treated as warnings and are not failing the validation."
fi

if [ ! -s $LOGFILE ] ;then
	rm "$LOGFILE"
else
	echo "To see the full output of the linter, download the archived artifact named '$LOGFILE'."
fi

exit $ret
#exit 0

