#!/bin/bash
LOGFILE=asn-validation.txt
DOCKER_IMAGE=forge.etsi.org:5050/li/schemas-definitions/asn1test:latest

echo "\n------ Checking for docker image --------"
docker pull "$DOCKER_IMAGE"

echo "------ Removing previous outputs --------"
if [ -f "$LOGFILE" ] ; then
    echo "Found previous log. Removing it"
    rm "$LOGFILE"
fi

echo "\n------ Validating ASN.1 files --------"
docker container run --rm -v $(pwd):/tmp/ -w "/tmp/" -u $(id -u):$(id -g) "$DOCKER_IMAGE" python3 asn_process.py &>>$LOGFILE >>$LOGFILE

exit $?

