#!/bin/bash
# Copyright ETSI 2020

LOGFILE=yang-validation.log
DOCKER_IMG=etsiforge/pyang:2.4.0-3gpp-d410f57

echo "------ Switching to $1 folder --------"
cd $1

echo "------ Content of the folder ------"
ls

echo "------ Checking for previous logs ------"
if [ -f "$LOGFILE" ] ; then
	echo "Found previous log. Removing it"
	rm "$LOGFILE"
fi

echo "------ Validating modified YANG files ------"
# If there are no YANG, JSON or XML files, then simply exit
ls | grep -q 'yang'
found_data_models=$?
if [ ! $found_data_models ] ; then 
    echo "-- No YANG files."
    exit 0
fi

# This must run error-free and must display all warnings to the user
docker pull -q "${DOCKER_IMG}"
#Validate all yang files
docker run --rm -v $(pwd)/yang-models:/yang "${DOCKER_IMG}" "/bin/sh" -c 'pyang --strict -p external-yams *.yang' 2>>$LOGFILE >>$LOGFILE
ret=$?

cat $LOGFILE

if [ $ret == 0 ] ; then
    echo "No errors found by pyang --strict validation."
fi

exit $ret

